set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11314331',
      19,
      39,
      '1444204',
      180.507570,
      0,
      0.210757,
      0,
      '123234',
      4,
      ' 2-27-1989',
      59.958340,
      46.505880,
      0.667328,
      NULL,
      5.722982,
      0,
      1.201670,
      1.645868,
      NULL,
      0,
      0.688562,
      NULL,
      1,
      0.655139,
      3,
      1,
      NULL,
      0,
      1.678249,
      1.909662,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1.771877,
      3,
      0,
      3.756528,
      NULL,
      0,
      1.790458,
      NULL,
      NULL,
      0.285619,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.245738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521058,
      1.592948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      4,
      3.145700,
      1,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      3.126608,
      0,
      1,
      0.838553,
      0,
      1,
      NULL,
      NULL,
      1,
      0.041338,
      0,
      NULL,
      4.529639,
      3.993114,
      0.886319,
      NULL,
      NULL,
      0.391898,
      2.026840,
      0,
      1.602075,
      5.887023,
      3.915769,
      NULL,
      NULL,
      8,
      NULL,
      3,
      8.658959,
      5.658232,
      8.176637,
      NULL,
      5,
      NULL,
      0.147372,
      1.851802,
      0,
      1.659474,
      6.589859,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632169,
      1.631159,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.949394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.384673,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.819396,
      0,
      NULL,
      NULL,
      NULL,
      7.748602,
      1,
      4.586905,
      4,
      1.334314,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.482565,
      1.153209,
      3.381415,
      1,
      NULL,
      3.758822,
      1,
      0.622094,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.505344,
      0,
      0,
      0.385545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '',
      '',
      1.138173,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      0.005960,
      NULL,
      0,
      3,
      3,
      3,
      NULL,
      1);
commit;
end;
/


