set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      '01442213',
      NULL,
      62.309327,
      '1343344',
      89,
      5,
      3.739226,
      1,
      '411124',
      NULL,
      ' 5-22-1983',
      NULL,
      NULL,
      1.586235,
      NULL,
      2,
      NULL,
      2.592961,
      0.168169,
      0.904432,
      1.676983,
      1.770410,
      3.570301,
      0.152388,
      1,
      5,
      1.249368,
      NULL,
      1.292178,
      1,
      0.952390,
      6.178243,
      1.315370,
      NULL,
      0.577942,
      NULL,
      1,
      5,
      0,
      1.602362,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.785964,
      NULL,
      NULL,
      6,
      6,
      1,
      1,
      1,
      1,
      NULL,
      2,
      1,
      1.557987,
      2,
      NULL,
      1,
      1.805396,
      1,
      3.239469,
      3.720958,
      1,
      3,
      1.964519,
      1,
      1.262997,
      2.575116,
      NULL,
      NULL,
      0.459461,
      0.253016,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.274681,
      NULL,
      5.251570,
      NULL,
      4.378226,
      0.017950,
      2.218806,
      0.820047,
      1.244218,
      NULL,
      NULL,
      1.795746,
      0,
      6,
      NULL,
      0.319954,
      0,
      0.010029,
      0.513857,
      NULL,
      NULL,
      0.023506,
      5,
      NULL,
      1.871700,
      1.134521,
      2.935649,
      NULL,
      3,
      1,
      1,
      NULL,
      2.248595,
      1,
      2.549367,
      2,
      1.160206,
      1,
      5.548468,
      1.036282,
      1,
      NULL,
      2,
      NULL,
      1.230589,
      NULL,
      0,
      4,
      NULL,
      NULL,
      1.275592,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440816,
      1,
      1,
      NULL,
      0,
      0.247171,
      1.035163,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.480503,
      2.600561,
      3.772219,
      1.395515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.258383,
      2,
      0.878028,
      NULL,
      NULL,
      NULL,
      7,
      1.377689,
      5.687511,
      4,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.588950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.224348,
      2.901113,
      0.748031,
      0,
      2,
      1.060004,
      1.750926,
      NULL,
      2,
      3.050344,
      0.584291,
      0,
      1,
      0.724200,
      0.775806,
      1,
      0.911222,
      NULL,
      1.464304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '44424',
      '',
      '',
      0.504847,
      '',
      '',
      '',
      0.016789,
      NULL,
      '',
      '',
      3,
      2,
      1,
      1,
      5.943087,
      3,
      0,
      NULL,
      0.716521);
commit;
end;
/


