set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '123',
      NULL,
      NULL,
      29,
      '0024221',
      94,
      5,
      1.849814,
      0,
      '231410',
      5.828045,
      '11-14-1986',
      10.665896,
      NULL,
      0.570638,
      NULL,
      0.453494,
      0.231564,
      0.187260,
      0,
      0.659561,
      0.130292,
      0,
      NULL,
      0,
      0.069162,
      7,
      1,
      NULL,
      0.055555,
      1.368494,
      1,
      3.920974,
      1.095258,
      0,
      1,
      1,
      1,
      9,
      0,
      1.456659,
      3.068386,
      2,
      1.925970,
      NULL,
      NULL,
      1.930654,
      NULL,
      NULL,
      6.547757,
      3.368484,
      0,
      3.202628,
      0,
      0.197935,
      1,
      1,
      1.247495,
      3.299905,
      2.523527,
      NULL,
      1.295600,
      NULL,
      1,
      3.718686,
      2.514317,
      NULL,
      2.310933,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      1.155224,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.608066,
      1,
      NULL,
      1.247016,
      NULL,
      6,
      1.585316,
      0.526472,
      NULL,
      5,
      0.321851,
      1,
      5.111767,
      1.587425,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.012009,
      NULL,
      7.402461,
      1.227814,
      1.416735,
      2,
      4.886919,
      NULL,
      0.646400,
      0.963958,
      0.553812,
      0,
      3,
      0.425718,
      2.614818,
      NULL,
      4,
      2.088482,
      2.037701,
      8.360029,
      8,
      5.717275,
      NULL,
      1,
      4,
      NULL,
      2,
      4.993903,
      1,
      0,
      0.702302,
      2.248085,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980428,
      NULL,
      0,
      NULL,
      0,
      0.038264,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.673411,
      NULL,
      3.401251,
      NULL,
      3,
      0.502393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1.137426,
      0.865901,
      NULL,
      NULL,
      NULL,
      4.491090,
      0.942304,
      4.542588,
      3.261140,
      3.014869,
      2,
      0.961534,
      NULL,
      NULL,
      NULL,
      1.852650,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.056578,
      3,
      2,
      1.058105,
      2,
      2,
      2.169461,
      0.041974,
      0,
      0.774862,
      0.053628,
      1,
      1.778381,
      0.762979,
      1,
      1.482767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.576136,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      5,
      2,
      3,
      2.649631,
      7,
      1.786617,
      0,
      0.108004,
      NULL);
commit;
end;
/


