set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2312',
      '11142422',
      NULL,
      51.708770,
      NULL,
      290,
      4,
      2,
      NULL,
      NULL,
      3,
      ' 4- 1-1981',
      24,
      NULL,
      1.572406,
      NULL,
      4.016901,
      NULL,
      0.398634,
      0,
      1,
      NULL,
      0.731918,
      3.801829,
      0.137993,
      1.311272,
      7,
      NULL,
      0,
      1,
      0.628510,
      3.850330,
      5,
      0,
      NULL,
      1,
      NULL,
      1.420788,
      1,
      0,
      5,
      3.215497,
      0,
      0.078277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.679111,
      4,
      NULL,
      2.455735,
      1,
      0,
      NULL,
      0,
      0,
      3.171799,
      0.832273,
      0.001029,
      1,
      NULL,
      1.089451,
      0.963227,
      1.214056,
      NULL,
      0.256500,
      NULL,
      1.783250,
      1,
      0.491375,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.669420,
      5.230654,
      2,
      NULL,
      2.719893,
      1,
      0.314048,
      0,
      0,
      5.847202,
      1.803794,
      1,
      1,
      7.995659,
      0,
      0.262488,
      0.748367,
      0,
      0.503825,
      NULL,
      1,
      NULL,
      2,
      0,
      2.047319,
      1.880461,
      4,
      0.427355,
      0,
      1.791632,
      1,
      3.493558,
      NULL,
      3.470373,
      3,
      2.082677,
      4.254552,
      6.670918,
      NULL,
      6,
      1,
      3,
      1.768468,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0.980440,
      0,
      1.221563,
      1.790542,
      1.304962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.401423,
      0,
      0,
      0.566242,
      1,
      0.350545,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272069,
      NULL,
      9,
      3.162548,
      0.341595,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.536291,
      2,
      1.297035,
      NULL,
      NULL,
      NULL,
      2.674046,
      1.871846,
      1,
      1,
      NULL,
      NULL,
      0.275059,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.297025,
      1.690502,
      2,
      1,
      0,
      1,
      2.052756,
      1,
      3.269146,
      0,
      0,
      NULL,
      0.430380,
      1.429458,
      NULL,
      1.269823,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '44311',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      6,
      NULL,
      1.853698,
      0,
      1,
      3.482454,
      3,
      2.557443,
      NULL);
commit;
end;
/


