set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30001034',
      34,
      NULL,
      '4224133',
      127.441087,
      1,
      NULL,
      0,
      '240131',
      4.132974,
      NULL,
      14,
      21,
      0,
      NULL,
      2,
      3.546168,
      1,
      0.916143,
      NULL,
      0.254851,
      3.173816,
      3,
      1.329690,
      0,
      3.974163,
      1,
      1,
      0,
      1.094475,
      3,
      1.485653,
      NULL,
      5,
      0.240925,
      1,
      0,
      1,
      NULL,
      4,
      4.155026,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1.421680,
      2,
      2,
      2.841752,
      1.846812,
      2,
      0,
      3.086225,
      3.994064,
      1.953404,
      NULL,
      0.835666,
      NULL,
      3.166588,
      2,
      NULL,
      2,
      6.037123,
      1,
      0,
      5,
      1,
      1,
      1.182753,
      0.991005,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      0.871572,
      0,
      NULL,
      NULL,
      4.637653,
      3.559718,
      0,
      1.175882,
      NULL,
      3,
      1,
      6.849519,
      0.207091,
      1,
      0.471211,
      0.716295,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.960576,
      NULL,
      8,
      0.837768,
      NULL,
      0.179358,
      0.647267,
      0,
      NULL,
      1.177295,
      5.186041,
      2.364387,
      0,
      6.786868,
      0,
      NULL,
      9,
      0,
      9,
      NULL,
      NULL,
      0,
      4,
      6.343040,
      2.468776,
      1.044430,
      1.718558,
      1.088930,
      3.136068,
      0.087945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.232927,
      0,
      1,
      0.195664,
      0.588951,
      NULL,
      0.825380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.338258,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.282636,
      2.851164,
      1.362521,
      1,
      1.050652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006790,
      1.702139,
      0.193937,
      1.307060,
      2,
      0.201482,
      NULL,
      0.403605,
      0,
      0,
      NULL,
      NULL,
      0,
      1.339248,
      1.590776,
      0,
      0.486948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.036457,
      '10203',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      1.621644,
      1.393158,
      NULL,
      5,
      1.663252,
      0,
      0.988700,
      NULL);
commit;
end;
/


