set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20101422',
      62.150348,
      49,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      40.396911,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      0,
      0.909398,
      1.923517,
      0,
      5,
      0.591827,
      1.349552,
      NULL,
      1.898829,
      NULL,
      3.548859,
      NULL,
      1.354147,
      1,
      NULL,
      1.830206,
      6.281508,
      1,
      2.357264,
      NULL,
      NULL,
      0.010368,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.335713,
      1.339180,
      NULL,
      1.030760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      4.283233,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1.927553,
      NULL,
      NULL,
      1.318142,
      2,
      NULL,
      NULL,
      2.392792,
      3,
      NULL,
      1,
      3,
      2.430180,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1,
      0.948173,
      1.539560,
      0,
      NULL,
      0,
      0,
      3,
      1.466838,
      3,
      1.358132,
      5,
      0,
      3.143032,
      1,
      1,
      2.523680,
      0,
      1.551254,
      0,
      3.673425,
      7.838481,
      4.593300,
      4,
      5,
      9.929144,
      7.529242,
      0,
      6.233467,
      4,
      5.946008,
      NULL,
      1.301706,
      3,
      1.808980,
      1,
      3.032218,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.769103,
      3,
      0.814579,
      1.470953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.781420,
      0,
      2.327972,
      NULL,
      2,
      0,
      1.998431,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311966,
      5,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.675447,
      9.047696,
      1.036786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.771683,
      0.339804,
      2,
      0.220149,
      0,
      3.544347,
      3.786236,
      0.231702,
      NULL,
      NULL,
      0,
      0.607884,
      NULL,
      1.125574,
      1.597977,
      0.862031,
      NULL,
      1.791857,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.307903,
      NULL,
      NULL,
      NULL,
      0.624072,
      '',
      '',
      NULL,
      0.655254,
      '',
      '',
      '',
      4,
      2,
      1.885079,
      1,
      1,
      NULL,
      2,
      1.363845,
      0.570806);
commit;
end;
/


