set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '14011131',
      48,
      46.365557,
      '3302213',
      241.393650,
      6,
      5,
      NULL,
      '211013',
      1.690952,
      ' 0-26-1993',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.546930,
      1,
      0,
      3.499013,
      0,
      1,
      0.855770,
      1.976091,
      1,
      1,
      0,
      1,
      NULL,
      1.263242,
      2,
      NULL,
      NULL,
      1.193753,
      1,
      0.371399,
      1.421355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.356690,
      0.187888,
      1.780760,
      0.770186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118542,
      1.939210,
      0.623076,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.907960,
      NULL,
      0.902584,
      0.348909,
      1,
      NULL,
      1,
      0.154892,
      4,
      4.462807,
      1,
      1.237146,
      2,
      1,
      0.889817,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.660361,
      1.734506,
      2.628570,
      NULL,
      NULL,
      0.673278,
      1.166472,
      0,
      0.166514,
      1,
      0.649276,
      0.516926,
      4.369726,
      4,
      5,
      0.956642,
      NULL,
      NULL,
      8,
      0,
      NULL,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      0.089623,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161503,
      0.415516,
      0,
      1,
      0.982599,
      1.062390,
      0,
      0.506866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116306,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.108014,
      0.604526,
      NULL,
      NULL,
      NULL,
      0,
      0.558128,
      6.481733,
      NULL,
      NULL,
      1,
      1.095567,
      NULL,
      NULL,
      NULL,
      1.528810,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351513,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      2,
      1,
      2.537740,
      3,
      1,
      0,
      0.331731,
      1.972375,
      1.366369,
      1,
      1,
      NULL,
      0,
      1.018293,
      1,
      NULL,
      1.661952,
      2.338920,
      3.036000,
      0,
      1.498521,
      NULL,
      NULL,
      1,
      0.675610,
      NULL,
      NULL,
      0.771945,
      1,
      1,
      NULL,
      NULL,
      0.043719,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.131051,
      '13440',
      '23411',
      NULL,
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      2,
      2.754088,
      2,
      2.635553,
      NULL,
      NULL,
      0,
      1);
commit;
end;
/


