set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '413',
      '42212220',
      49,
      1,
      '2111341',
      219,
      6,
      5,
      NULL,
      NULL,
      NULL,
      ' 5-24-1999',
      55,
      16.449511,
      0.481632,
      NULL,
      0.390401,
      0.997730,
      0,
      1.036884,
      1.922679,
      0,
      1,
      1,
      1,
      1.998359,
      0,
      1.726840,
      1,
      3.388020,
      0.611541,
      0,
      2,
      1,
      1,
      0,
      1,
      0.122945,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846579,
      0.632438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.527388,
      0.077391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.164352,
      NULL,
      NULL,
      0.877729,
      NULL,
      7.884720,
      1,
      1.667195,
      1.053140,
      4.143991,
      1,
      NULL,
      NULL,
      0.972311,
      1.205735,
      0.567775,
      1,
      NULL,
      NULL,
      1.131887,
      0.394399,
      0,
      0,
      0,
      NULL,
      3.407253,
      1.402196,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.143470,
      0,
      5,
      1.127757,
      4.930768,
      8.081392,
      1,
      NULL,
      5,
      5,
      6,
      8.730657,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4.897959,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      0,
      1,
      1.549161,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141481,
      2.577794,
      1.344732,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.452706,
      0.098160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.454122,
      1.596482,
      NULL,
      0,
      3.978820,
      2,
      3.985172,
      3,
      NULL,
      3,
      2,
      NULL,
      0,
      0,
      0.260306,
      0.279386,
      1,
      1,
      1.565659,
      1,
      0,
      0.609763,
      0,
      0.102971,
      NULL,
      1.271723,
      2,
      1.904226,
      NULL,
      0,
      NULL,
      1.580821,
      1.991466,
      0.031087,
      0.387128,
      1,
      1.860448,
      0,
      0.911944,
      0.257860,
      1,
      0,
      0.648513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.562093,
      '41331',
      NULL,
      '',
      1.347499,
      '',
      '',
      '',
      0.964895,
      '',
      '',
      '',
      NULL,
      NULL,
      0,
      NULL,
      1.041594,
      1,
      NULL,
      1.005297,
      NULL);
commit;
end;
/


