set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44033341',
      66.380667,
      23,
      '3013322',
      282,
      6,
      3.933159,
      3,
      '212412',
      1,
      NULL,
      44.732262,
      149,
      1.770172,
      NULL,
      NULL,
      0.220265,
      NULL,
      NULL,
      1,
      0.540581,
      1.628838,
      2,
      0.204642,
      0.105363,
      1,
      0,
      NULL,
      3,
      0,
      1,
      0,
      1.175600,
      1,
      0,
      1,
      0.099448,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732643,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900840,
      1.327068,
      0,
      1.559511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463348,
      1,
      1,
      NULL,
      4.493672,
      7,
      1,
      NULL,
      0,
      3.693867,
      1,
      0.679754,
      2,
      1.349349,
      1.794407,
      1,
      NULL,
      0.967370,
      NULL,
      0,
      1,
      5,
      NULL,
      0,
      1.880702,
      4.452531,
      1.798807,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624773,
      NULL,
      NULL,
      4.159733,
      4,
      NULL,
      3.268297,
      4.009387,
      7,
      NULL,
      5.423410,
      NULL,
      1.216671,
      0,
      1.707502,
      1.757928,
      1.812164,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536378,
      NULL,
      2,
      0,
      1.536704,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      7.736697,
      0.839828,
      6,
      0,
      1.543484,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.874295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.413494,
      1,
      NULL,
      0.815506,
      NULL,
      2.597869,
      NULL,
      1.128454,
      NULL,
      1.993493,
      NULL,
      0.875798,
      0.708581,
      0.565495,
      1.442709,
      1,
      0,
      1,
      1.996888,
      0.051561,
      1,
      1,
      1,
      1,
      2.636121,
      3,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      0.270316,
      NULL,
      0,
      NULL,
      0.366349,
      0.045963,
      1.735192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '10231',
      '10144',
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      0.632811,
      2,
      3,
      3,
      2.564721,
      1.318140,
      1,
      2);
commit;
end;
/


