set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      39.861182,
      70,
      '2020421',
      308.583033,
      NULL,
      0,
      NULL,
      '420111',
      1,
      ' 5-29-1992',
      27,
      56,
      1.875504,
      NULL,
      0,
      NULL,
      2.189181,
      NULL,
      NULL,
      0.940480,
      2,
      3,
      1,
      1,
      1.132569,
      0,
      0.520673,
      2.355458,
      0.309891,
      1,
      NULL,
      NULL,
      1.222666,
      1.001615,
      0,
      0,
      3.971627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161922,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.510095,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.844955,
      0,
      0.307764,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      4,
      0.967475,
      1.808400,
      3.571791,
      1.408955,
      1,
      0,
      0,
      1,
      NULL,
      0.953228,
      NULL,
      3,
      NULL,
      0,
      1.425687,
      3.384414,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1.663394,
      4.319779,
      5.680095,
      2.665452,
      NULL,
      NULL,
      4,
      1.154910,
      3.721122,
      5,
      7.923514,
      NULL,
      0.581736,
      NULL,
      1,
      NULL,
      NULL,
      3.438849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.308559,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.296005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759196,
      0.648262,
      2.438961,
      0.319991,
      1.104820,
      1,
      0.100000,
      NULL,
      NULL,
      NULL,
      1.900050,
      0.781795,
      0.461172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.715538,
      1.074015,
      1.575268,
      1.751946,
      2.335250,
      1,
      3.599482,
      0,
      0.464900,
      0,
      1,
      3.906737,
      NULL,
      0.722404,
      1,
      1,
      1,
      0,
      1.536340,
      NULL,
      1,
      1,
      1.929272,
      NULL,
      3.666029,
      NULL,
      1,
      0.991149,
      1,
      0,
      1.931700,
      1,
      1,
      NULL,
      0,
      NULL,
      0.819039,
      0.488554,
      1,
      NULL,
      NULL,
      1.401695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '22423',
      '34402',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      5.705298,
      0,
      2.763779,
      NULL,
      0.744970,
      1.775060,
      NULL,
      3,
      0);
commit;
end;
/


