set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '110',
      '01114141',
      57,
      24.205982,
      NULL,
      269.616020,
      3,
      1,
      2,
      '130040',
      5,
      ' 0-21-1995',
      34,
      NULL,
      0.782109,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      0.837661,
      0.134439,
      0.032597,
      NULL,
      NULL,
      0,
      0,
      0.171608,
      1,
      3,
      NULL,
      2,
      0.114878,
      1.820816,
      1.523587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.376576,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.447493,
      1,
      1.060015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.694079,
      0.973728,
      0.321585,
      0.949271,
      2,
      0,
      0.325561,
      1,
      3.902456,
      5.695555,
      0,
      1.541107,
      5,
      0.238388,
      0,
      0,
      NULL,
      0.801783,
      NULL,
      1,
      1,
      1.844514,
      NULL,
      1.958304,
      1,
      2.653029,
      NULL,
      1,
      1.280877,
      0,
      1.606120,
      1.423488,
      NULL,
      NULL,
      0.751826,
      2.923498,
      7.191292,
      0.850653,
      NULL,
      0.936627,
      4.001850,
      NULL,
      NULL,
      NULL,
      0,
      0.542192,
      0.779778,
      0,
      NULL,
      NULL,
      0,
      1.406624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.930353,
      0,
      1,
      2,
      0,
      1.815499,
      1.882915,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.286002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.390788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.459562,
      3,
      2.477351,
      NULL,
      2.515077,
      1,
      3.769304,
      1,
      3,
      0.573055,
      1,
      0,
      1,
      1,
      0.618726,
      1.005489,
      3,
      0.499998,
      0,
      NULL,
      1,
      0.033670,
      2.747537,
      3,
      NULL,
      0.624857,
      NULL,
      1.633886,
      NULL,
      1,
      NULL,
      NULL,
      1.907699,
      0.225090,
      0,
      0,
      0.101892,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.619559,
      '44333',
      '42040',
      '',
      1.080161,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      5,
      2.483624,
      NULL,
      2.516018,
      NULL,
      3.930681,
      2,
      0.642805);
commit;
end;
/


