set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      '33324132',
      35,
      31.559675,
      NULL,
      NULL,
      6,
      2.761388,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.037096,
      1.054906,
      1.173953,
      1,
      0,
      0,
      2.329297,
      1,
      0.631939,
      1.344332,
      2.277648,
      NULL,
      1.801054,
      3,
      0.321732,
      1.484686,
      0,
      1,
      2,
      NULL,
      1.884301,
      1.867587,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666266,
      1,
      1.230233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.605926,
      1.493515,
      0.927415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730081,
      1.916510,
      0.561988,
      0,
      0.451358,
      0.174325,
      4.816794,
      NULL,
      NULL,
      NULL,
      5,
      0.571773,
      1,
      1.169635,
      1.662666,
      0.578805,
      NULL,
      1,
      0.029059,
      NULL,
      1.115224,
      NULL,
      0.056678,
      NULL,
      0.967468,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.383382,
      NULL,
      0.687781,
      3.781492,
      NULL,
      5.448608,
      3.217091,
      6,
      6,
      NULL,
      2,
      7,
      4,
      1,
      0,
      0,
      1.279375,
      NULL,
      NULL,
      0,
      1.786373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.507609,
      2,
      0,
      0,
      1,
      NULL,
      1.976427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.949017,
      1.911866,
      2,
      0.075874,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584015,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      3,
      NULL,
      3.460367,
      1.108117,
      1,
      0,
      3.185122,
      3,
      0.548906,
      0,
      1,
      0.095077,
      NULL,
      1,
      3.243171,
      0.633095,
      1.820920,
      1.329552,
      1,
      3,
      3.301942,
      NULL,
      1,
      1.415944,
      1.307583,
      0.183427,
      0.880080,
      NULL,
      0,
      1,
      1.618305,
      1.008077,
      NULL,
      1.145334,
      0,
      NULL,
      NULL,
      0.274438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '14232',
      '22433',
      '',
      1.039036,
      '',
      '',
      '',
      1.727047,
      '',
      '',
      NULL,
      3.167080,
      5.935622,
      NULL,
      1,
      3.078787,
      2,
      2.116784,
      3,
      1.310316);
commit;
end;
/


