set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1433',
      '30232014',
      40,
      NULL,
      NULL,
      206,
      5,
      NULL,
      3,
      '224312',
      0,
      NULL,
      64,
      39,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      1.577661,
      NULL,
      0,
      0.329269,
      0,
      0,
      0,
      0.315658,
      0,
      0.000149,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1.611396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203915,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.644421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618983,
      0,
      1.702393,
      0.774598,
      1.732514,
      0,
      4.267066,
      NULL,
      0,
      0.302481,
      2.381618,
      NULL,
      1,
      NULL,
      0.075939,
      0.877877,
      0.144019,
      1.708267,
      0,
      NULL,
      1,
      1.816774,
      0.515326,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0.512487,
      1,
      0.923753,
      0.603577,
      4.807330,
      NULL,
      NULL,
      1.335730,
      3,
      NULL,
      4,
      1.472984,
      NULL,
      5.808119,
      0,
      NULL,
      1,
      0.950905,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.044774,
      1.609239,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.902095,
      1.672804,
      1.686235,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      NULL,
      0,
      1.274210,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.158779,
      0,
      1,
      1,
      1,
      0.052601,
      NULL,
      0.539618,
      3,
      3.127974,
      1.971389,
      NULL,
      1,
      1.913991,
      NULL,
      1.503807,
      0.492910,
      1.082574,
      1.136985,
      1.125962,
      1,
      1,
      1,
      NULL,
      0,
      0.525187,
      NULL,
      NULL,
      1.968980,
      0.272609,
      1.893832,
      1,
      NULL,
      0.496032,
      0,
      0,
      1.371117,
      1.747555,
      1.152879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '32032',
      '04404',
      '',
      NULL,
      '',
      '',
      NULL,
      0.399160,
      '',
      '',
      '',
      2.403127,
      2,
      2,
      1,
      NULL,
      0.513133,
      2.692426,
      1,
      NULL);
commit;
end;
/


