set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20301412',
      75.562492,
      NULL,
      NULL,
      304,
      NULL,
      0.723507,
      0,
      NULL,
      1.915979,
      ' 2-11-1980',
      22,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.590826,
      0,
      0.140242,
      1,
      0,
      2.756551,
      2.659451,
      0,
      0.430223,
      NULL,
      1,
      1.619928,
      1.280888,
      NULL,
      0.920075,
      NULL,
      1.889320,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910984,
      1.060384,
      1.357497,
      1.649769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.495736,
      NULL,
      1.463432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.197517,
      NULL,
      NULL,
      1.416611,
      0,
      0,
      1.849304,
      0.916874,
      1.472005,
      1.015072,
      1,
      2,
      0,
      1,
      0,
      0.950258,
      NULL,
      NULL,
      1.491501,
      1.952791,
      1.039432,
      NULL,
      1.875135,
      0,
      NULL,
      3.839041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.610394,
      3.721571,
      NULL,
      1,
      5,
      5.402334,
      2,
      5,
      NULL,
      3.332212,
      7,
      NULL,
      1,
      NULL,
      1.018144,
      NULL,
      NULL,
      6.384266,
      0.548984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863098,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.311855,
      0,
      0,
      1,
      5,
      1.243253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.420026,
      5.676480,
      1,
      NULL,
      0,
      1.810272,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.652759,
      1,
      1,
      1.308899,
      NULL,
      0.462930,
      1,
      1.849816,
      3.506059,
      2,
      1,
      NULL,
      NULL,
      0.455907,
      NULL,
      0.498643,
      0.736864,
      0.462618,
      0.252973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '30210',
      '',
      1.823103,
      '',
      '',
      NULL,
      0.897366,
      '',
      '',
      NULL,
      NULL,
      4.638892,
      2.437372,
      NULL,
      3.116696,
      3.195304,
      3.714785,
      1.018257,
      0);
commit;
end;
/


