set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0021',
      NULL,
      88.175122,
      54,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '323040',
      1.962048,
      ' 7- 3-1975',
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      0.204204,
      2,
      1.705258,
      NULL,
      NULL,
      3,
      NULL,
      1.400873,
      NULL,
      0.330379,
      1.191466,
      NULL,
      0,
      0,
      0.166423,
      0,
      0.374374,
      1.410428,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.511043,
      0,
      1.454905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1.322133,
      0.041665,
      1,
      NULL,
      0,
      1.829445,
      1,
      0,
      NULL,
      1.159912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.485452,
      NULL,
      NULL,
      2,
      6.640628,
      NULL,
      8.006896,
      8,
      6,
      0.488946,
      4,
      2.393122,
      0.359999,
      1.324853,
      1,
      0,
      NULL,
      NULL,
      0.936855,
      0.552582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070127,
      0,
      2,
      0,
      1.154108,
      NULL,
      1,
      1.334626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.755820,
      1.342119,
      NULL,
      NULL,
      NULL,
      6.377138,
      0.026468,
      1.175912,
      1,
      0,
      1,
      0.513655,
      NULL,
      NULL,
      NULL,
      0.692438,
      3.163496,
      1.750096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639014,
      0,
      0,
      1,
      3.722507,
      3,
      3,
      1,
      1,
      2,
      2,
      2.119820,
      0.683280,
      0.477935,
      0.609757,
      0.074340,
      1,
      1.660627,
      NULL,
      0.434834,
      NULL,
      1,
      NULL,
      0,
      0.315959,
      0.559021,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '11013',
      '13431',
      NULL,
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1.667957,
      NULL,
      0,
      NULL,
      0.290574,
      1.069076,
      0.736176,
      2.604100,
      0.448309);
commit;
end;
/


