set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      '310341',
      NULL,
      ' 7-27-1975',
      11,
      NULL,
      1.379339,
      NULL,
      1,
      NULL,
      1.557844,
      1,
      NULL,
      1.248659,
      0.370988,
      0.819774,
      1.213624,
      0,
      0.469111,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0.686439,
      1,
      0,
      NULL,
      NULL,
      3.717660,
      0,
      1.026659,
      1.082807,
      NULL,
      NULL,
      1.244781,
      NULL,
      NULL,
      6,
      1,
      0.220888,
      NULL,
      1,
      1,
      1,
      NULL,
      1.768034,
      2,
      0,
      1,
      0,
      0,
      NULL,
      2.143921,
      2,
      0.753611,
      1.320616,
      0,
      NULL,
      5.467178,
      4,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0.277367,
      NULL,
      NULL,
      0.618859,
      1.509511,
      0.286536,
      0,
      NULL,
      0,
      0.884869,
      0,
      1,
      0.959682,
      1.590743,
      0,
      1.285797,
      0,
      NULL,
      0.043303,
      0,
      NULL,
      1.343938,
      NULL,
      1.379572,
      1,
      NULL,
      0.722050,
      2,
      1.252854,
      0.451852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.100777,
      1,
      0,
      0.026105,
      1,
      3,
      NULL,
      0.852225,
      2.860563,
      0,
      0.785415,
      NULL,
      3,
      1,
      6.650684,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752125,
      0.086787,
      NULL,
      0,
      0.612522,
      1.185471,
      0.899486,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848178,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443153,
      0,
      NULL,
      2.973625,
      3.654562,
      12.812416,
      NULL,
      1,
      0.985441,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.065565,
      1.692559,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.955787,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      2.579651,
      1.981693,
      NULL,
      1.525777,
      1,
      1,
      1.083176,
      0,
      1.471798,
      0.370666,
      1,
      1,
      1.481155,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.133275,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


