set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '4141440',
      2,
      4,
      0.224649,
      0,
      '112142',
      NULL,
      ' 8-24-1976',
      26,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0.380407,
      1.510568,
      NULL,
      1.909364,
      NULL,
      1.986262,
      NULL,
      1.812799,
      1,
      0,
      1,
      0.533648,
      1,
      0.404746,
      NULL,
      0,
      1.624747,
      1.282222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.690230,
      1,
      2.250789,
      0.552963,
      NULL,
      1,
      0.274291,
      1.656291,
      0,
      1,
      0.037352,
      1,
      3,
      2,
      1.793070,
      NULL,
      1.534576,
      1,
      0,
      NULL,
      1.863723,
      0,
      1,
      1,
      1,
      1.497913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.192409,
      NULL,
      1.775548,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0.094336,
      0.872525,
      0,
      1.924824,
      1,
      1.836964,
      1.010596,
      NULL,
      0.592519,
      0,
      0,
      1.123907,
      1.153752,
      1,
      5,
      0.376779,
      3.549484,
      5,
      0.396797,
      1.845325,
      NULL,
      0,
      1,
      1.566842,
      0,
      1,
      2.044889,
      2,
      NULL,
      1.599405,
      0.649012,
      4.020134,
      NULL,
      NULL,
      11.936194,
      1.554817,
      1,
      NULL,
      NULL,
      NULL,
      1.595610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1.893182,
      1,
      1.042969,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0.823759,
      NULL,
      NULL,
      NULL,
      1.240623,
      1.726224,
      NULL,
      0.405114,
      0.336169,
      NULL,
      1.924981,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.400862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113638,
      1,
      1.459824,
      NULL,
      1,
      NULL,
      NULL,
      1.647966,
      0.724140,
      1,
      0.712756,
      1,
      0,
      0,
      0.841236,
      1,
      1,
      0,
      0,
      1.102557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176013,
      '21011',
      '',
      '',
      0.967682,
      '',
      NULL,
      '',
      1.305120,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


