set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      10,
      3,
      0,
      3,
      '203420',
      3,
      ' 1-26-1984',
      33,
      NULL,
      1,
      NULL,
      5.674888,
      0.748086,
      0,
      1,
      0.298600,
      3,
      1,
      1.613109,
      NULL,
      NULL,
      1.625423,
      0,
      NULL,
      0,
      NULL,
      5,
      1,
      NULL,
      1.827089,
      0,
      1.402576,
      0.416740,
      NULL,
      0,
      NULL,
      NULL,
      0.486302,
      0.478719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.145972,
      0.946848,
      3,
      1,
      1.918133,
      2.748835,
      1.187266,
      1,
      NULL,
      NULL,
      0.434480,
      3.484466,
      3.134843,
      3.062487,
      1,
      NULL,
      NULL,
      0.489430,
      0.067872,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      0.318802,
      NULL,
      NULL,
      0.838028,
      NULL,
      NULL,
      0.409076,
      0.225943,
      1.048515,
      NULL,
      0,
      NULL,
      0,
      0.647554,
      NULL,
      1,
      NULL,
      1.022021,
      1.539989,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4,
      3.034590,
      1,
      5,
      0.151186,
      2.066531,
      0,
      3.317525,
      1.585139,
      0,
      0.340248,
      NULL,
      0,
      2.053017,
      0.111695,
      1.153493,
      NULL,
      5,
      NULL,
      1,
      1.297319,
      0,
      0.753653,
      2,
      NULL,
      1.073037,
      NULL,
      1.316873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1.999175,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.972496,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948004,
      NULL,
      1.544262,
      2,
      3.603000,
      1.535312,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.075926,
      0.912321,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036102,
      1.411079,
      0.402202,
      0,
      0,
      NULL,
      1.919818,
      3,
      1,
      0,
      0,
      0.820609,
      1.273464,
      NULL,
      0.732733,
      0.938588,
      0.280550,
      1.508088,
      1.585656,
      0.345380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.755057,
      '24424',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.025045,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


