set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '42',
      12.057974,
      NULL,
      NULL,
      32.975600,
      3,
      2.374128,
      0,
      '343401',
      2,
      NULL,
      57.631776,
      17.127395,
      NULL,
      NULL,
      15,
      1.383181,
      NULL,
      0,
      1.360773,
      1.489610,
      1.729175,
      2,
      1,
      NULL,
      3.488595,
      0.654749,
      1,
      1.436709,
      1,
      2.230505,
      3,
      0.016192,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530520,
      NULL,
      0.376844,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.772223,
      6,
      0,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      0.386516,
      NULL,
      NULL,
      0,
      1,
      1.613986,
      1.226978,
      0,
      1.947115,
      0,
      0.577728,
      0,
      1.456473,
      0.350726,
      NULL,
      0,
      1.744998,
      1,
      1,
      0.461729,
      1,
      1.203545,
      NULL,
      0.115565,
      NULL,
      1,
      0,
      0.255020,
      NULL,
      2.002691,
      1.472487,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0.422367,
      0,
      0,
      1,
      1,
      1,
      0,
      1.115448,
      2.485918,
      3,
      0.341921,
      3.963709,
      3,
      0,
      NULL,
      NULL,
      0.172407,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.110897,
      0,
      2,
      1,
      NULL,
      1,
      1.591491,
      1.994160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453242,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.805535,
      0.390757,
      1.689635,
      NULL,
      NULL,
      NULL,
      1.932720,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.106636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169681,
      0.025730,
      0.618665,
      3.333698,
      1.090445,
      NULL,
      0,
      0.335246,
      1.649664,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0.696237,
      NULL,
      0,
      1,
      0.958069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.094516,
      '32332',
      '',
      '',
      1.841667,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


