set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      12.822272,
      16,
      '1003304',
      108,
      3,
      1.866459,
      0,
      NULL,
      NULL,
      ' 7-21-1991',
      10.642435,
      NULL,
      1,
      NULL,
      7,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      0.366581,
      1,
      0.929309,
      1.706778,
      NULL,
      NULL,
      0.892179,
      0.870156,
      NULL,
      1,
      0.234287,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.040368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.336013,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.247404,
      0.217869,
      0.694216,
      0,
      1.267351,
      0,
      1.665356,
      1,
      1.756683,
      0.247539,
      0,
      0,
      NULL,
      0.957398,
      NULL,
      1.063629,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.404226,
      1,
      0.666526,
      3.309446,
      0.519282,
      5,
      0.345656,
      NULL,
      1.790041,
      NULL,
      NULL,
      1.845131,
      1.260977,
      0,
      NULL,
      0.690915,
      0.245005,
      1.457357,
      2,
      0.576110,
      NULL,
      3.887813,
      NULL,
      2,
      0.630455,
      9.437981,
      2,
      NULL,
      NULL,
      NULL,
      7,
      1.798018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.856888,
      1,
      1,
      0,
      0,
      1.201717,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045077,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.786747,
      0,
      NULL,
      NULL,
      NULL,
      0.587251,
      0.834345,
      1,
      1.471734,
      NULL,
      1,
      0.054961,
      NULL,
      NULL,
      NULL,
      1,
      2.025520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.616038,
      2.998400,
      NULL,
      2,
      1.486119,
      0,
      NULL,
      NULL,
      1,
      0.267906,
      0.915421,
      1,
      1,
      NULL,
      0,
      1.214776,
      0.801369,
      1.179531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '13222',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.886608,
      '',
      '',
      '',
      5.889866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


