set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      '02',
      26.590678,
      38.818325,
      '4120022',
      32,
      NULL,
      0,
      NULL,
      '102401',
      2.093553,
      ' 8-16-1993',
      28,
      53,
      NULL,
      NULL,
      9,
      NULL,
      1.191349,
      0.760317,
      1.036041,
      NULL,
      1,
      2,
      0,
      NULL,
      0.202101,
      0.804339,
      1.585231,
      0.881771,
      NULL,
      1,
      1.997211,
      0.506097,
      1.816587,
      1.029204,
      NULL,
      0.325292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192371,
      0.301539,
      NULL,
      1.442554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.220729,
      NULL,
      NULL,
      0.708151,
      0,
      NULL,
      1,
      NULL,
      0.058413,
      1.321908,
      NULL,
      0,
      NULL,
      NULL,
      0.961907,
      1.462122,
      0.628862,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0.886991,
      0,
      0,
      1.383483,
      0,
      2,
      0,
      2,
      NULL,
      NULL,
      1,
      1.996675,
      1.334718,
      3,
      5.567000,
      NULL,
      NULL,
      3.678522,
      2,
      0.553079,
      1.544927,
      3,
      5.341444,
      3,
      1,
      0.697328,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.805636,
      1,
      1,
      0,
      1,
      1.036626,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954727,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.201798,
      1,
      NULL,
      NULL,
      NULL,
      0.812187,
      0,
      2,
      1.382775,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.149581,
      1.402298,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966269,
      1.977010,
      0.757295,
      2.729388,
      1.163115,
      0,
      1,
      3,
      NULL,
      1.673540,
      1,
      0.577758,
      0,
      NULL,
      NULL,
      NULL,
      0.091601,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.280718,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.903760,
      NULL,
      '',
      '',
      4.780173,
      3,
      2.537723,
      4,
      NULL,
      0,
      0,
      2.213116,
      2);
commit;
end;
/


