set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '121',
      NULL,
      24,
      36,
      '0200242',
      172,
      1,
      2.870347,
      2,
      '243313',
      NULL,
      NULL,
      23.600902,
      NULL,
      0.448469,
      NULL,
      NULL,
      0.963781,
      1.743659,
      1,
      1,
      2.535902,
      1,
      NULL,
      1.859250,
      1.000032,
      1.142810,
      1,
      1,
      NULL,
      0.075552,
      1,
      0.905787,
      NULL,
      0,
      0.701035,
      0.904679,
      0.010040,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794734,
      0,
      5.902083,
      2.158747,
      NULL,
      2,
      2.772311,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.910187,
      1.171250,
      1,
      1.138611,
      1.937212,
      NULL,
      NULL,
      1.650039,
      1.538183,
      1,
      1.408948,
      1.692109,
      NULL,
      1.396059,
      NULL,
      0.394810,
      1.297008,
      0.021634,
      NULL,
      NULL,
      2,
      0.834723,
      1.089670,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.757839,
      0.152930,
      1,
      1.898395,
      1.719170,
      NULL,
      1.945839,
      0.044556,
      NULL,
      0.544097,
      1,
      1,
      1,
      3.590120,
      6,
      7.936163,
      NULL,
      1.136356,
      1,
      1.215362,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277460,
      0,
      1,
      1.974098,
      0.880823,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.591152,
      NULL,
      NULL,
      NULL,
      NULL,
      0.814910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.885613,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.505571,
      1,
      1.270800,
      1,
      1,
      1,
      NULL,
      0.653329,
      0.791783,
      1.511327,
      NULL,
      0.579894,
      0,
      1,
      1,
      1.238780,
      1.626083,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.564549,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0.168542,
      '',
      '',
      '',
      NULL,
      1.907995,
      NULL,
      NULL,
      3,
      0,
      1,
      1.984592,
      2.024741);
commit;
end;
/


