set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '03313334',
      41,
      60,
      '0001013',
      265,
      1,
      NULL,
      3,
      '030344',
      0,
      ' 6-10-1999',
      1,
      NULL,
      0.523779,
      NULL,
      2.155101,
      1.080582,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.150982,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.909715,
      0,
      1.833675,
      1.769830,
      1,
      0.931905,
      0.953057,
      1,
      0,
      0.291997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132945,
      0,
      0.489529,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      6,
      2,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.205662,
      NULL,
      1,
      1.975289,
      0,
      1.724058,
      1,
      NULL,
      0,
      1,
      1,
      0.348555,
      1.860925,
      NULL,
      0,
      0,
      NULL,
      0.455085,
      3,
      NULL,
      0,
      3,
      NULL,
      3.784741,
      1.269022,
      1.579356,
      1,
      0,
      1,
      1,
      0.450761,
      NULL,
      NULL,
      NULL,
      1.769575,
      1.126529,
      NULL,
      NULL,
      0.334848,
      1,
      5,
      4.468889,
      NULL,
      0.686508,
      0,
      NULL,
      NULL,
      NULL,
      4.704607,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436534,
      1,
      1,
      NULL,
      1.601454,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.969838,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.553565,
      1.831026,
      0,
      0,
      0.758524,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457580,
      0.465570,
      1.229429,
      NULL,
      1.496420,
      3.988935,
      0,
      0,
      0.645276,
      NULL,
      NULL,
      1.761713,
      1.759613,
      0,
      NULL,
      0.497866,
      0.671395,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.329161,
      '40021',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.484035,
      3,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1);
commit;
end;
/


