set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '433',
      '04013341',
      61,
      13.459365,
      '2043330',
      83,
      NULL,
      0,
      3,
      '242100',
      0.846674,
      ' 5-16-1980',
      55,
      50,
      0.974553,
      NULL,
      0,
      3.939062,
      0,
      0,
      1.355074,
      NULL,
      0,
      0.772054,
      1,
      NULL,
      1,
      0,
      1,
      0.155709,
      0,
      0.759666,
      1,
      0.130191,
      1.185100,
      0.772161,
      0.039267,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.855942,
      0,
      0.331176,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      1,
      1.745566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.654300,
      1.735474,
      0.055426,
      0,
      NULL,
      NULL,
      1.676287,
      NULL,
      0,
      0.582060,
      NULL,
      NULL,
      0.590101,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.098335,
      NULL,
      0.966627,
      NULL,
      1.502862,
      1.051276,
      1,
      1.932289,
      2,
      0,
      0.254364,
      1,
      1,
      1,
      1,
      0.414522,
      1.188987,
      0,
      0.465044,
      1.940781,
      1,
      1,
      4.325739,
      1,
      0,
      3.964184,
      NULL,
      1.795974,
      1,
      NULL,
      0,
      NULL,
      NULL,
      8.610315,
      1.746651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.089348,
      0,
      1,
      0.795559,
      1,
      0.106614,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803308,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.323050,
      2,
      1.957165,
      NULL,
      NULL,
      NULL,
      1,
      0.261640,
      NULL,
      NULL,
      0.228739,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.964128,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.642440,
      NULL,
      1.391825,
      NULL,
      1.458592,
      NULL,
      0,
      1,
      0.002418,
      0.901002,
      1.600691,
      NULL,
      1.730064,
      NULL,
      1,
      1.269257,
      1,
      1.523554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '04430',
      '',
      NULL,
      0,
      NULL,
      '',
      NULL,
      0,
      NULL,
      NULL,
      '',
      3,
      0,
      0.532407,
      3,
      2.499219,
      1.975057,
      2.390258,
      NULL,
      3);
commit;
end;
/


