set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11231014',
      36.145962,
      56,
      '2320221',
      286,
      NULL,
      3.967304,
      2,
      '023230',
      0.412269,
      ' 5- 4-1989',
      NULL,
      52,
      NULL,
      NULL,
      7.523314,
      1,
      3.169846,
      0.151322,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0.553940,
      1,
      1.456199,
      0.766533,
      1.623873,
      1.357337,
      0.977369,
      1.322925,
      NULL,
      0,
      NULL,
      1.905955,
      1.834939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312575,
      0,
      0.935830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.625128,
      4.784107,
      NULL,
      1,
      0,
      NULL,
      0.143840,
      NULL,
      NULL,
      1.528402,
      NULL,
      NULL,
      0.285409,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0.029925,
      0.450132,
      1.958828,
      1.049749,
      NULL,
      0.955728,
      1.822954,
      0,
      1,
      1.257100,
      0.885147,
      1.712539,
      NULL,
      0.582270,
      NULL,
      0.954720,
      NULL,
      1.771583,
      1.968505,
      0,
      0,
      0,
      NULL,
      NULL,
      1.282251,
      NULL,
      1.108872,
      1,
      0,
      1.287540,
      NULL,
      NULL,
      1,
      1.553133,
      NULL,
      NULL,
      7,
      7,
      1,
      1,
      0.693908,
      0,
      NULL,
      NULL,
      6,
      1.164037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.101190,
      NULL,
      1,
      1,
      1,
      0.936171,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505193,
      1,
      3.347065,
      NULL,
      0.945514,
      0,
      1.825147,
      NULL,
      NULL,
      NULL,
      0.540882,
      0.560732,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681743,
      0.713852,
      1,
      2.277769,
      1,
      0,
      NULL,
      0.078505,
      1,
      0,
      0.512181,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.379621,
      '33000',
      '',
      '',
      0.522485,
      NULL,
      '',
      '',
      1.192062,
      '',
      '',
      NULL,
      1,
      3.714739,
      0.633530,
      3,
      3.014054,
      0,
      0,
      1,
      3.427625);
commit;
end;
/


