set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8828666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23034311',
      NULL,
      NULL,
      '1101343',
      87.564763,
      NULL,
      0.813176,
      0,
      '440441',
      4.150568,
      ' 5-13-2000',
      NULL,
      59.308674,
      0,
      NULL,
      1.553736,
      0.908837,
      3,
      1,
      0.577274,
      NULL,
      0.958515,
      0.726825,
      1.605783,
      0,
      1.274376,
      0.485912,
      1,
      0.425229,
      0.531516,
      0.469565,
      1.172132,
      0,
      0.114695,
      0.795524,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579350,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100397,
      1,
      1,
      1.599881,
      NULL,
      0,
      1.972354,
      1,
      1,
      1.086285,
      0.847495,
      1.774190,
      1,
      1.495787,
      NULL,
      1,
      0.029946,
      1.173997,
      NULL,
      NULL,
      1.883781,
      1.203592,
      1.918327,
      0.463889,
      1.486186,
      NULL,
      0.125500,
      1.058737,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.368966,
      0.625158,
      0.119051,
      1,
      0,
      NULL,
      0.893323,
      1.459251,
      NULL,
      NULL,
      0,
      1,
      1,
      1.729270,
      NULL,
      1,
      NULL,
      NULL,
      2.772152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263299,
      0.948005,
      0,
      0,
      1,
      NULL,
      NULL,
      0.861655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.362747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      2.349468,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.447905,
      0.763386,
      1.769113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675363,
      1,
      0,
      1.982864,
      3.324448,
      1,
      1.919231,
      0.635082,
      NULL,
      NULL,
      0.163174,
      0.638174,
      NULL,
      1,
      1.764218,
      1,
      NULL,
      1,
      1.877346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.270314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.003931,
      NULL,
      NULL,
      NULL,
      NULL,
      1.239926,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.125925,
      NULL,
      0,
      0,
      0,
      2,
      4.572330,
      '34423',
      '42240',
      '',
      1.888416,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      0.068553,
      3.721214,
      3.377399,
      0,
      0,
      1,
      NULL,
      1);
commit;
end;
/


