set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '0401311',
      49.836581,
      NULL,
      1,
      NULL,
      NULL,
      3,
      ' 6-22-1993',
      37.290755,
      NULL,
      1.908756,
      NULL,
      1,
      0.083025,
      0,
      NULL,
      0,
      NULL,
      1.698369,
      1.721305,
      1.284085,
      1.045295,
      NULL,
      1.296871,
      0.715562,
      0.777727,
      NULL,
      0.155483,
      1.233651,
      0,
      1,
      0.501143,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.865037,
      1,
      0,
      NULL,
      1.727915,
      0.856028,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.644898,
      0,
      1,
      1.345278,
      NULL,
      1.071610,
      0.080097,
      NULL,
      1.245904,
      1.507670,
      1.735875,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.966591,
      0,
      0,
      0,
      1.566746,
      3.454495,
      1,
      0,
      0,
      2,
      1,
      NULL,
      0,
      0,
      0.292394,
      NULL,
      NULL,
      0,
      1,
      0.837948,
      1.731155,
      1.456199,
      0,
      NULL,
      1.089749,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      1.481723,
      NULL,
      2,
      1.514274,
      3.377697,
      0,
      NULL,
      1,
      0,
      1.524301,
      1.999563,
      1.415492,
      5,
      1,
      NULL,
      NULL,
      0,
      1.681106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235385,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.229915,
      0.581604,
      0.802039,
      0.108404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.437158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.959651,
      0,
      1.184651,
      0.191745,
      1.703952,
      1,
      0.470902,
      NULL,
      NULL,
      NULL,
      0.553662,
      NULL,
      1.483395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585681,
      1.086172,
      1,
      1,
      1.557153,
      1,
      NULL,
      1,
      0,
      1,
      0.628539,
      0,
      0.094850,
      0.951321,
      0.127841,
      1.884711,
      NULL,
      1,
      1.576925,
      0.145933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.482904,
      '24300',
      '',
      '',
      1,
      '',
      '',
      '',
      0.231505,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


