set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-10-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      110.940714,
      3,
      3,
      0,
      '022201',
      3.984555,
      ' 3- 1-1981',
      56.803356,
      NULL,
      1.830899,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.021192,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.880169,
      0,
      1,
      1.862733,
      0,
      1,
      0.750458,
      0,
      0,
      0.199763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.919222,
      0,
      1.609040,
      1.380196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463410,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.998920,
      1,
      1,
      1,
      1,
      0,
      0.852806,
      1.388493,
      1.418923,
      NULL,
      NULL,
      0.275865,
      1.829591,
      0,
      0.527717,
      1.192287,
      1,
      0.882542,
      NULL,
      0.008049,
      1,
      1,
      0.569883,
      0.205313,
      1.768616,
      0.038409,
      3.141330,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828662,
      1.726106,
      0,
      1.002578,
      0.870334,
      1.737215,
      0,
      1,
      NULL,
      0,
      2,
      3,
      3,
      0,
      NULL,
      1,
      1.532575,
      NULL,
      NULL,
      8.403972,
      1.458481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767484,
      1,
      NULL,
      0,
      NULL,
      1,
      1.136084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236037,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5.083933,
      1.888255,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.678695,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.415433,
      0.192050,
      0,
      0,
      0,
      NULL,
      0.348333,
      0,
      1.827010,
      0,
      0,
      0.165898,
      0,
      1.883837,
      0.787515,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '24412',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.940555,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


