set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      NULL,
      31.552836,
      10,
      NULL,
      73.803906,
      0,
      NULL,
      3,
      '313311',
      2.552942,
      ' 3- 2-1975',
      17.770243,
      NULL,
      0.056922,
      NULL,
      0.612959,
      1.487026,
      1,
      NULL,
      1.428715,
      1.847491,
      0,
      0,
      1,
      1,
      0.275681,
      1.976445,
      0,
      0,
      NULL,
      NULL,
      1.445065,
      NULL,
      1,
      0,
      0.911908,
      1,
      1.182463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680469,
      0,
      1.745752,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.581372,
      1.953966,
      0.009871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.257959,
      NULL,
      2.609588,
      NULL,
      NULL,
      0,
      1.181190,
      0.306636,
      1,
      1,
      0,
      NULL,
      1.894894,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.881352,
      1,
      NULL,
      NULL,
      0.575209,
      NULL,
      NULL,
      1,
      1.711331,
      4,
      1.703005,
      5.843206,
      0.516067,
      NULL,
      0.943841,
      NULL,
      1.824554,
      1,
      3,
      3,
      3,
      0,
      NULL,
      0.803042,
      NULL,
      0,
      NULL,
      NULL,
      4.905585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.425255,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.825170,
      NULL,
      4,
      NULL,
      0.666045,
      0,
      1.048499,
      0.516615,
      3.896287,
      0.951242,
      0.438122,
      1.128318,
      0,
      0.283314,
      0,
      NULL,
      1.537920,
      0,
      1.662703,
      6.915319,
      2,
      0,
      2,
      0.642722,
      1,
      NULL,
      NULL,
      1,
      3.840472,
      3.126348,
      1.209434,
      3,
      6,
      5.371537,
      3.426789,
      1.600761,
      0.934278,
      NULL,
      NULL,
      NULL,
      0.499438,
      2,
      3,
      2,
      0,
      2,
      1.849785,
      0.753036,
      0.913788,
      1.656936,
      NULL,
      0,
      NULL,
      1.007633,
      0.023875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.425827,
      '03120',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


