set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '042',
      NULL,
      34,
      63.308158,
      '4211314',
      170.223432,
      NULL,
      NULL,
      3,
      NULL,
      2.950713,
      ' 5- 6-2001',
      42,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0.094323,
      1.851491,
      1.603847,
      0,
      NULL,
      0,
      1.763838,
      1,
      NULL,
      1.795656,
      1.696497,
      1,
      1,
      0.552177,
      1.054929,
      1,
      0.264599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.767791,
      1,
      3.919759,
      0,
      0.505562,
      1,
      0.379225,
      0.998606,
      1.709305,
      0.717062,
      1,
      NULL,
      0,
      1,
      0.091006,
      3.488814,
      NULL,
      0.595031,
      NULL,
      0.187268,
      0.207967,
      0.993488,
      0.047159,
      0,
      2,
      0.811866,
      NULL,
      NULL,
      NULL,
      0.142559,
      NULL,
      NULL,
      1,
      4.010204,
      NULL,
      1,
      2,
      1.853111,
      1.587534,
      1,
      1,
      1,
      1.549571,
      0,
      1.324601,
      NULL,
      1,
      1,
      1.912538,
      0,
      NULL,
      NULL,
      NULL,
      0.491131,
      NULL,
      1,
      0.494522,
      1.912931,
      0.936384,
      0.015618,
      4.215790,
      1,
      1,
      1,
      1,
      1.484182,
      4,
      1,
      1,
      NULL,
      0,
      1.109580,
      5,
      NULL,
      NULL,
      5,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.105063,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1.849301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      2,
      0,
      1.392207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3.505457,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109730,
      0.907014,
      NULL,
      0.396101,
      0.966565,
      1,
      NULL,
      0,
      1.984124,
      1.784836,
      0.915744,
      NULL,
      0,
      1.810901,
      NULL,
      1.259272,
      NULL,
      1,
      1.225404,
      1.931529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '32142',
      '33321',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      1,
      NULL,
      0.420004,
      0,
      3,
      3,
      1.982495);
commit;
end;
/


