set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20041233',
      10.673104,
      56.734578,
      NULL,
      255,
      NULL,
      NULL,
      0,
      NULL,
      3.332771,
      ' 5-17-1993',
      46.695595,
      27.628576,
      1.211522,
      NULL,
      1.832182,
      NULL,
      1.300266,
      0.680091,
      1.297910,
      NULL,
      1,
      0.077414,
      0,
      0,
      0.777459,
      1.905155,
      NULL,
      NULL,
      0,
      0.798290,
      1.278593,
      1.158667,
      NULL,
      0.311032,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.699416,
      1.728017,
      0,
      3,
      1,
      1.029717,
      1,
      1.994193,
      0,
      NULL,
      0.666378,
      1,
      0,
      0.795773,
      0.264681,
      NULL,
      NULL,
      1.970611,
      0.512277,
      5,
      1,
      0,
      NULL,
      1.865711,
      NULL,
      NULL,
      1.465473,
      NULL,
      NULL,
      1.034620,
      5,
      0,
      1.442483,
      2,
      1.910716,
      NULL,
      NULL,
      0,
      4.472300,
      1.142796,
      0,
      0,
      4,
      0,
      1.076593,
      NULL,
      0,
      1.349812,
      NULL,
      1.516281,
      1.723455,
      0.129675,
      NULL,
      0,
      0,
      0.205122,
      1,
      2.600405,
      NULL,
      1,
      0,
      0.923330,
      1,
      4,
      0,
      1.058741,
      1.059283,
      0.059571,
      0,
      0.190479,
      0,
      0.071311,
      2,
      5,
      0.113222,
      0,
      1.800531,
      0,
      NULL,
      NULL,
      4.844316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020434,
      0,
      NULL,
      1,
      1,
      0,
      0.733514,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      NULL,
      0.305347,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.436115,
      2.451396,
      1.045344,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.561787,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.190358,
      0,
      2.826166,
      0.887766,
      3.613574,
      0.497997,
      0.161696,
      0,
      1,
      1,
      0.852942,
      0,
      0.359837,
      NULL,
      1.133440,
      NULL,
      1.196822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.903673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '10403',
      '31321',
      '',
      0.127721,
      '',
      '',
      '',
      1.065880,
      '0402',
      '',
      NULL,
      2.287526,
      3,
      NULL,
      3,
      2,
      5.346825,
      3,
      NULL,
      2);
commit;
end;
/


