set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30302440',
      NULL,
      50.166315,
      '2443342',
      55,
      0,
      2,
      NULL,
      '413002',
      0,
      ' 3-12-1999',
      20,
      15,
      0,
      NULL,
      1,
      0,
      NULL,
      0.800373,
      1,
      0.984003,
      2,
      1,
      0,
      1.140014,
      0.636621,
      1.684282,
      1,
      0.066476,
      1.415037,
      NULL,
      0.004487,
      0.826502,
      0,
      1.991295,
      1.144411,
      1.563392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.323865,
      NULL,
      1,
      0,
      3,
      1.873120,
      0.194946,
      0.867546,
      3.862589,
      0.116744,
      1.175863,
      0,
      2.919487,
      NULL,
      0,
      0.492379,
      0.789018,
      1.945513,
      1,
      1.980237,
      3,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.158918,
      3,
      NULL,
      1,
      1,
      NULL,
      1.607321,
      0,
      1,
      5.713116,
      1,
      0,
      1,
      0,
      NULL,
      0.834833,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.454789,
      NULL,
      0.298032,
      NULL,
      1,
      0.233931,
      1.836136,
      2,
      0,
      0.319994,
      0,
      1.201555,
      1.326108,
      1,
      0.972181,
      0.940094,
      0.874725,
      NULL,
      1.928273,
      0,
      0,
      2,
      2.277779,
      2.050939,
      0.933591,
      1.229000,
      2.124426,
      0,
      NULL,
      NULL,
      0.645714,
      1.124946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150036,
      1.789117,
      NULL,
      0,
      0.322483,
      0.485197,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.527743,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.608591,
      2,
      3.384815,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.576307,
      0.806145,
      1.523937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970252,
      0,
      0.648994,
      1,
      1,
      2.949546,
      1.525444,
      3.029694,
      NULL,
      0.563454,
      NULL,
      1.732920,
      0,
      0,
      0,
      0,
      0,
      0.868450,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '22000',
      '',
      '',
      0.927267,
      NULL,
      '',
      '',
      1.619115,
      '1204',
      '',
      '',
      1,
      3.409563,
      NULL,
      3,
      NULL,
      NULL,
      3,
      2,
      3.335660);
commit;
end;
/


