set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '313',
      '41312002',
      73.928167,
      6.395806,
      '0033342',
      NULL,
      NULL,
      3,
      3,
      '014002',
      5,
      ' 9- 1-2002',
      NULL,
      47.908118,
      0.555752,
      NULL,
      0,
      1.019920,
      NULL,
      0,
      1,
      1.188687,
      3.029849,
      1,
      0.016105,
      NULL,
      0,
      0.363474,
      1,
      0,
      1,
      1,
      NULL,
      1.815113,
      NULL,
      1,
      1,
      1.071122,
      0.484855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      2,
      0,
      0,
      1,
      0,
      0.311146,
      1,
      3,
      0,
      2.518087,
      1.932675,
      2,
      1,
      1.668933,
      1.118133,
      NULL,
      4,
      1.309365,
      0,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.419168,
      NULL,
      NULL,
      0.430607,
      NULL,
      0.681214,
      0,
      0,
      1,
      1.413806,
      0,
      0,
      0,
      0,
      NULL,
      0.319256,
      2,
      0.355267,
      1,
      0.202949,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.909944,
      0,
      0.153589,
      NULL,
      4.558594,
      0.770877,
      NULL,
      5,
      0.240654,
      1.401536,
      2.419082,
      NULL,
      0.706267,
      1,
      1,
      0.278373,
      2.805732,
      1,
      1,
      0.733180,
      NULL,
      0,
      NULL,
      0,
      0.480402,
      NULL,
      NULL,
      6.195233,
      1.826397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327739,
      0.777018,
      NULL,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.113911,
      1.832708,
      3.809207,
      NULL,
      0,
      NULL,
      NULL,
      1.529259,
      NULL,
      2,
      NULL,
      1.862490,
      NULL,
      NULL,
      NULL,
      0,
      0.032554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.949992,
      0,
      1,
      0.285395,
      0.659163,
      0.846104,
      NULL,
      3.191743,
      NULL,
      0,
      0.915547,
      1,
      1.032786,
      0,
      NULL,
      NULL,
      0,
      1.787747,
      1,
      1.460604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      NULL,
      1.102569,
      '',
      '',
      '',
      0,
      '2203',
      '',
      '',
      3.954862,
      4,
      3,
      3.910874,
      NULL,
      0.882263,
      3,
      0,
      0.740957);
commit;
end;
/


