set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1341',
      '44444324',
      41,
      NULL,
      '3240210',
      NULL,
      6,
      3.113480,
      3,
      '342413',
      4.071373,
      '11-23-1974',
      48.028793,
      35.605778,
      1,
      NULL,
      0.110456,
      NULL,
      1,
      0,
      0,
      NULL,
      1.088468,
      NULL,
      0,
      1,
      1,
      NULL,
      1.109675,
      1.268870,
      0.983134,
      NULL,
      NULL,
      0.022440,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.935735,
      1.021119,
      1,
      2.780754,
      NULL,
      1,
      NULL,
      0.603863,
      2.089459,
      0.645991,
      1,
      0,
      NULL,
      0,
      1.890293,
      0.853674,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      1,
      0,
      2,
      1.216954,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.121368,
      1,
      2.401901,
      1.782776,
      3.932289,
      0,
      1,
      1.387180,
      1.492350,
      NULL,
      0.115425,
      NULL,
      0.110877,
      NULL,
      1.847329,
      0,
      1.484656,
      0,
      NULL,
      NULL,
      1.775248,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1.444336,
      1,
      NULL,
      0.054729,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1.534184,
      0.029737,
      0,
      1,
      0.963348,
      0,
      2,
      4.510289,
      0,
      1.167553,
      1,
      1,
      NULL,
      NULL,
      5.564054,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484656,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534530,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.425354,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.790910,
      0,
      1.127613,
      1,
      1,
      NULL,
      1,
      1,
      1.231225,
      NULL,
      1.749350,
      0.850285,
      0,
      NULL,
      1.864723,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      '',
      '',
      0.300062,
      '',
      '',
      NULL,
      0.651456,
      '0041',
      NULL,
      NULL,
      0.693395,
      0.052678,
      3.512325,
      1,
      1,
      NULL,
      3,
      3,
      3.351397);
commit;
end;
/


