set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2032',
      NULL,
      NULL,
      65,
      '4431030',
      103.895531,
      5,
      0.829618,
      NULL,
      '442411',
      4,
      '10- 7-2001',
      10,
      33,
      1,
      NULL,
      11.761334,
      3.335981,
      0,
      0.010053,
      3.240623,
      1,
      3.703966,
      0,
      0.668629,
      NULL,
      1,
      0,
      1.495602,
      0,
      0.065884,
      1.851042,
      0,
      0,
      1.177084,
      1.864669,
      NULL,
      1.844088,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.437882,
      0.987054,
      NULL,
      0,
      2.298855,
      1,
      0.807007,
      1,
      NULL,
      1.475588,
      1,
      1,
      2,
      1.560486,
      NULL,
      0,
      0.748819,
      NULL,
      1,
      1.922935,
      2,
      1,
      0,
      0.232252,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5,
      1,
      1.687239,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1.161001,
      0,
      1,
      0.422764,
      0.795216,
      0.469674,
      NULL,
      NULL,
      1.985841,
      1.788121,
      0.118198,
      1,
      1,
      0.993344,
      0,
      2.866834,
      1,
      1,
      0.502689,
      1,
      0.910027,
      2.544390,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0.082504,
      NULL,
      2,
      1,
      4,
      3.181453,
      0,
      NULL,
      NULL,
      2.374641,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.848460,
      0,
      NULL,
      NULL,
      0.756707,
      0.285113,
      1.746635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.405466,
      0.238072,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.277138,
      0,
      1.696281,
      0.098494,
      0.962018,
      0.507855,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.462221,
      1.893610,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0.574076,
      '1411',
      '0244',
      '',
      2.399736,
      2,
      3,
      NULL,
      1.900598,
      1,
      1.169193,
      1,
      3);
commit;
end;
/


