set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12141204',
      NULL,
      67,
      '0421000',
      411.807402,
      NULL,
      NULL,
      2,
      '113431',
      2.963561,
      ' 2-13-2000',
      42,
      30.740612,
      NULL,
      NULL,
      0.691292,
      3.588670,
      1,
      1,
      0.592703,
      0,
      3.387310,
      1.307186,
      1,
      0,
      1.625104,
      1,
      0,
      0,
      NULL,
      1.857758,
      0.046086,
      NULL,
      1.090784,
      NULL,
      1.960089,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.610961,
      0,
      NULL,
      0.379217,
      1,
      0.723645,
      NULL,
      0,
      3.799225,
      1,
      3.458296,
      1.838388,
      3,
      1.705110,
      1,
      1.941457,
      NULL,
      1,
      NULL,
      0,
      1.067251,
      1.257747,
      5,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.292580,
      NULL,
      NULL,
      0,
      4,
      0,
      1.494914,
      4,
      NULL,
      0.501764,
      1.865902,
      0,
      NULL,
      0,
      0.965087,
      0,
      1,
      1,
      0.243677,
      1,
      0,
      0,
      NULL,
      0.620969,
      1,
      1,
      1.186634,
      0,
      1.984988,
      0,
      1.248559,
      2.664037,
      1,
      1.659077,
      NULL,
      1.110427,
      0.188080,
      1.098035,
      NULL,
      NULL,
      0.252011,
      1,
      0.789630,
      1,
      0,
      NULL,
      4,
      2,
      1.134949,
      2.490948,
      0,
      0.603397,
      NULL,
      NULL,
      0,
      1.925495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0.474452,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1.827352,
      NULL,
      NULL,
      NULL,
      0.156575,
      1,
      1.089317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.970052,
      1,
      1.165793,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      0,
      0.324346,
      NULL,
      1,
      0.267738,
      1,
      1.319947,
      1.506853,
      1.860382,
      0.607108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '24100',
      '',
      NULL,
      1.876051,
      '',
      NULL,
      '',
      0,
      '4002',
      NULL,
      '',
      1.613733,
      NULL,
      NULL,
      NULL,
      0.520089,
      1,
      3,
      1,
      2.425038);
commit;
end;
/


