set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3422',
      '30400221',
      35.837408,
      80.797761,
      '0023312',
      131,
      2,
      0.001106,
      2,
      '421430',
      4,
      NULL,
      26.726433,
      24.686178,
      1,
      NULL,
      9,
      2,
      1.532011,
      0,
      2,
      1,
      1,
      1,
      0,
      0.194362,
      0.927965,
      1,
      NULL,
      0.797312,
      1.764010,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.651180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.916779,
      0.562201,
      0,
      NULL,
      1.763077,
      1,
      1,
      1,
      2,
      NULL,
      3.219872,
      0,
      0,
      NULL,
      NULL,
      2.976912,
      1.551939,
      1.869714,
      1,
      0.425134,
      0,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.552960,
      2.694642,
      0,
      1,
      3,
      0.298839,
      1.581481,
      0.690195,
      1.071287,
      1.252453,
      0,
      0.507603,
      1,
      0.943026,
      1,
      NULL,
      NULL,
      0.705185,
      1.623038,
      NULL,
      0,
      0,
      NULL,
      1.864391,
      1,
      0,
      0.370278,
      0.028447,
      3.325597,
      NULL,
      1.722712,
      4.320300,
      0,
      1,
      1,
      0.462914,
      3.770802,
      1.793075,
      2,
      2,
      0.103764,
      0.438247,
      0.119989,
      0.744989,
      NULL,
      0.415688,
      2,
      NULL,
      0.556623,
      NULL,
      NULL,
      8,
      0.575737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.536313,
      NULL,
      NULL,
      NULL,
      NULL,
      0.948233,
      0.189747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      1.020308,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.156618,
      1.720266,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.658611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298355,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.737600,
      2.881439,
      NULL,
      NULL,
      0.510870,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590619,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      3.784604,
      '2030',
      '2024',
      '',
      4.692185,
      NULL,
      2.452521,
      5,
      0,
      3,
      NULL,
      3,
      3);
commit;
end;
/


