set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '1313222',
      1,
      5,
      NULL,
      2,
      '342103',
      NULL,
      ' 0-16-1977',
      37.492610,
      NULL,
      1,
      NULL,
      0,
      2.760630,
      0,
      1,
      0.005815,
      2,
      0.521631,
      1,
      NULL,
      NULL,
      1,
      0,
      0.597585,
      0,
      1,
      6.291732,
      0,
      1.201118,
      1.505520,
      0,
      1,
      1.264769,
      5,
      0,
      1.103796,
      1.212226,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.831409,
      0.776228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109743,
      1.915808,
      NULL,
      0,
      1,
      1.308438,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698406,
      0,
      1,
      1.631377,
      NULL,
      0,
      0,
      0.495428,
      0.962481,
      1.686436,
      0.103935,
      NULL,
      0.114186,
      NULL,
      NULL,
      1.436332,
      0,
      0,
      NULL,
      NULL,
      0.645392,
      1.172157,
      NULL,
      0.558808,
      NULL,
      0.511112,
      0.399369,
      NULL,
      NULL,
      1.171882,
      0,
      0,
      1.982310,
      0,
      0,
      NULL,
      1.261559,
      0,
      0.544106,
      4.716794,
      1.343862,
      1.855660,
      6.463648,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.062561,
      NULL,
      1.966980,
      NULL,
      1.268243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051579,
      0.687469,
      NULL,
      1,
      1,
      1.016104,
      1,
      0.434201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.253688,
      0.648745,
      5,
      0,
      5.046608,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.486277,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462610,
      0,
      0,
      0.949708,
      3,
      NULL,
      NULL,
      1,
      1.032738,
      1.837972,
      0.062893,
      1.271440,
      0.698468,
      0,
      0,
      0.474949,
      NULL,
      0,
      1.029290,
      0.343816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.284468,
      '04322',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1.643105,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


