set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '3334000',
      13.662111,
      6,
      NULL,
      NULL,
      NULL,
      0,
      '10-13-1984',
      18,
      NULL,
      1.567137,
      NULL,
      0,
      0.949322,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.539150,
      1.137850,
      NULL,
      1,
      1,
      1.297617,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905862,
      1,
      1.133953,
      0,
      2.612357,
      0,
      2.739821,
      1,
      0.816024,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.337661,
      1,
      NULL,
      1.962983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.405463,
      NULL,
      NULL,
      0,
      1,
      0.918957,
      1.589536,
      0,
      NULL,
      1.009266,
      0.882425,
      NULL,
      2,
      NULL,
      1,
      0,
      1,
      NULL,
      0.168930,
      NULL,
      1,
      1,
      NULL,
      1.965832,
      1,
      0,
      1.622213,
      1,
      1.417296,
      0,
      1.697509,
      0,
      0.578061,
      1.447592,
      1,
      1,
      1,
      0.151597,
      0.150120,
      NULL,
      0,
      0.015798,
      NULL,
      NULL,
      NULL,
      NULL,
      6.597060,
      2,
      1,
      0.460979,
      1.505349,
      1.276339,
      0.074376,
      1.269262,
      8.357065,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160584,
      1.298798,
      1,
      1,
      1.494200,
      0.322471,
      0.785274,
      0.425233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      8.066806,
      2.023457,
      0,
      3,
      0,
      3.447237,
      0,
      0.219496,
      2,
      4.844468,
      0.854563,
      1,
      1.898738,
      NULL,
      3.414261,
      1.771062,
      1,
      1,
      0,
      NULL,
      NULL,
      4,
      1.573893,
      NULL,
      NULL,
      1,
      0.267312,
      1.250533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470089,
      1,
      1.258959,
      3,
      NULL,
      1,
      1,
      0,
      1.652507,
      0.884973,
      1.792481,
      1.607399,
      NULL,
      0.251293,
      0.985333,
      0.076244,
      0.778714,
      NULL,
      1,
      0.288491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '21324',
      NULL,
      '',
      0.995382,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


