set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '2433311',
      40,
      1,
      NULL,
      1,
      '414023',
      1,
      NULL,
      36,
      NULL,
      0.344225,
      NULL,
      2.726431,
      0.765178,
      1.533530,
      1.358280,
      3,
      0,
      1,
      0,
      1.368367,
      1.268596,
      0.123755,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1.847566,
      1,
      0,
      1,
      0,
      1.192341,
      NULL,
      1.033406,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.757261,
      0.727285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.463608,
      1.598261,
      NULL,
      1.764211,
      NULL,
      1,
      0.731007,
      1.756420,
      NULL,
      NULL,
      0.189491,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.005317,
      1.186473,
      0.276134,
      1.023079,
      NULL,
      1.405132,
      0.397568,
      0,
      1,
      0,
      0,
      0.506657,
      0,
      NULL,
      NULL,
      0.546834,
      0,
      NULL,
      0.284918,
      1.337999,
      0,
      0,
      1.554317,
      0.455640,
      1,
      NULL,
      0,
      1.808557,
      1.999528,
      0,
      NULL,
      0.306505,
      0.159097,
      NULL,
      0,
      1.884857,
      2.382469,
      0.856348,
      2,
      2.360501,
      NULL,
      0.195846,
      1,
      3,
      1.232608,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.290866,
      1,
      0,
      1.110348,
      1.335318,
      1.287613,
      0.769033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698688,
      NULL,
      NULL,
      NULL,
      NULL,
      1.938723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.862057,
      1.890326,
      1.402394,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.519371,
      0,
      0.352331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.727599,
      NULL,
      NULL,
      1,
      1.762731,
      NULL,
      NULL,
      0,
      0.358380,
      1,
      1,
      0,
      0,
      1.096194,
      1.032723,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '11144',
      '',
      NULL,
      0.462806,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


