set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '242',
      '23',
      8.915991,
      1,
      '2013120',
      108,
      NULL,
      NULL,
      NULL,
      '230121',
      5.566562,
      ' 5-23-1978',
      40,
      10,
      1,
      NULL,
      3.155819,
      1.270668,
      0.787424,
      0.335793,
      1.406057,
      0.220845,
      1.729458,
      1.031061,
      NULL,
      1.461719,
      1.215931,
      NULL,
      0,
      1.712503,
      1.224584,
      9.808019,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      2,
      0.373531,
      0,
      0.359680,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.174019,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.804022,
      1.920210,
      1.366313,
      0,
      0,
      NULL,
      NULL,
      1.782375,
      NULL,
      NULL,
      1.639836,
      NULL,
      NULL,
      NULL,
      1.982528,
      0,
      0.769190,
      1,
      NULL,
      0.603419,
      NULL,
      NULL,
      NULL,
      1.150774,
      1,
      0,
      1.323639,
      0.379448,
      1.200155,
      1.272835,
      1.525393,
      0,
      NULL,
      0.146339,
      NULL,
      1.850497,
      1.448113,
      NULL,
      1,
      0.259361,
      NULL,
      1.490578,
      1.088994,
      0.335755,
      0,
      1.252111,
      1.204939,
      1,
      1,
      NULL,
      NULL,
      0.685786,
      1,
      0,
      5.214504,
      5,
      0,
      NULL,
      1,
      0.752203,
      1.995926,
      3,
      0.494024,
      0,
      9.044461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975875,
      NULL,
      0,
      0,
      1.330242,
      1.769997,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422062,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.214764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963233,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.042926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      0.690630,
      1,
      0.820498,
      1,
      NULL,
      1.715080,
      0,
      NULL,
      0,
      1.782422,
      0.565353,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '4341',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.498756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


