set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13',
      43.398951,
      25,
      '2434232',
      45.300718,
      6,
      3,
      2,
      '040103',
      NULL,
      ' 6-19-1982',
      16,
      125.190099,
      1.242270,
      NULL,
      0.502988,
      1,
      2,
      0.452383,
      NULL,
      2,
      0.776269,
      NULL,
      0.023551,
      0.908621,
      1.436260,
      0.813853,
      NULL,
      1,
      1,
      NULL,
      1,
      0.556273,
      0,
      1,
      NULL,
      1.022549,
      NULL,
      0,
      4,
      0.268908,
      0.613424,
      1.125839,
      NULL,
      NULL,
      1.625637,
      NULL,
      NULL,
      1.125863,
      0.156245,
      1,
      1.393187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      0.190203,
      1.116028,
      0.386990,
      1,
      0,
      NULL,
      0.727016,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.954215,
      1,
      1.931925,
      1.394942,
      1.303527,
      1,
      NULL,
      NULL,
      0,
      0.257587,
      1,
      NULL,
      1,
      0,
      0.028526,
      1,
      1.722548,
      NULL,
      0.545965,
      0.631959,
      0,
      0,
      1,
      1,
      1,
      1.830409,
      NULL,
      0,
      0,
      1.219879,
      NULL,
      0,
      0.233790,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      2.788116,
      7,
      1.809983,
      1.935379,
      0.741652,
      3.120866,
      1.209190,
      1,
      7,
      1.935318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1.916830,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.741632,
      NULL,
      4,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.699442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.353594,
      0.853865,
      NULL,
      1,
      3.269541,
      0,
      NULL,
      1.595170,
      1.932786,
      1.587479,
      1,
      0.213037,
      0,
      1,
      NULL,
      1,
      0.115838,
      NULL,
      0.620783,
      1.925497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.112239,
      '1411',
      '',
      '',
      0.850845,
      '',
      '',
      NULL,
      0.191410,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


