set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '30',
      15,
      NULL,
      '4444122',
      58.803081,
      0,
      NULL,
      1,
      '411212',
      3,
      NULL,
      0,
      48,
      0,
      NULL,
      2.004705,
      1,
      3.603839,
      1.431804,
      0,
      3.151501,
      1,
      NULL,
      0.854239,
      0.566207,
      0,
      0,
      0,
      1.065863,
      1,
      2.560086,
      0.019992,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.123860,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665101,
      1.514321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      0.116186,
      NULL,
      1,
      1,
      0.368867,
      NULL,
      NULL,
      1.739095,
      NULL,
      NULL,
      0.107655,
      0.018319,
      1,
      0,
      1.915778,
      1,
      0,
      1,
      0.611964,
      NULL,
      1,
      1.617941,
      0,
      0,
      1.366794,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      1.750783,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0.280988,
      1.732787,
      0.475752,
      0,
      NULL,
      1,
      0.994752,
      0,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      2.527884,
      3,
      NULL,
      0.075262,
      0.103380,
      0.108595,
      1.545933,
      1,
      4,
      0.139612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435891,
      NULL,
      NULL,
      0,
      1.872287,
      NULL,
      1.520806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333848,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.576089,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.243443,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.317397,
      3.428840,
      1,
      1.044638,
      NULL,
      0,
      0,
      1.696257,
      1,
      0,
      1.930098,
      0,
      NULL,
      0,
      NULL,
      0,
      1.193475,
      1.925680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.195316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.642886,
      '3332',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


