set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '430',
      '13211131',
      39,
      NULL,
      '1030313',
      16,
      5,
      3,
      0,
      '203233',
      NULL,
      ' 0-13-1990',
      7.709103,
      1.543690,
      1.938979,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.508537,
      2,
      0.438615,
      0,
      0,
      0.499687,
      0.783007,
      1.655370,
      0.132487,
      NULL,
      1,
      4.589825,
      NULL,
      1.727109,
      0,
      1.388691,
      0.476072,
      0,
      1.760268,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.194329,
      NULL,
      NULL,
      0.177812,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.237669,
      1.043700,
      NULL,
      1.974576,
      NULL,
      0,
      NULL,
      1.227253,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.928155,
      1,
      1.523222,
      0,
      NULL,
      1.090444,
      0,
      NULL,
      1.497496,
      1.781805,
      0.700402,
      NULL,
      0.228467,
      NULL,
      1,
      1.333012,
      1,
      NULL,
      0.792467,
      NULL,
      0,
      1,
      1.512169,
      0,
      NULL,
      NULL,
      1.006706,
      0.861201,
      NULL,
      NULL,
      0,
      0,
      1.612413,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      3.924031,
      2,
      4,
      0,
      NULL,
      0,
      1.521792,
      1,
      1.072453,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974346,
      1,
      1,
      0,
      NULL,
      0,
      0.876867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.448799,
      0,
      NULL,
      0.360408,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.618748,
      0.031431,
      1.566770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252938,
      0.268231,
      0.349634,
      0,
      1.253833,
      0.514041,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0.067307,
      1,
      NULL,
      1.063045,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.527131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      2.117262,
      0.460792,
      NULL,
      3.659445,
      NULL,
      NULL,
      3.866700,
      3,
      NULL);
commit;
end;
/


