set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01443031',
      23.103144,
      NULL,
      '2230400',
      141.255434,
      1,
      1,
      3,
      '122200',
      5,
      NULL,
      10,
      139,
      1,
      NULL,
      3,
      0,
      3,
      0.816391,
      NULL,
      NULL,
      1,
      0,
      0.300226,
      1,
      NULL,
      0,
      1.742688,
      1,
      1,
      7.843673,
      NULL,
      0.103155,
      NULL,
      0,
      0,
      NULL,
      2.366838,
      0,
      5.612194,
      0,
      1,
      0.003704,
      NULL,
      NULL,
      0.715072,
      NULL,
      NULL,
      0.354398,
      0.877136,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747809,
      NULL,
      3,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.800783,
      0,
      1.321057,
      NULL,
      1,
      NULL,
      1,
      1.201695,
      1.529790,
      1.202019,
      1.508484,
      0,
      1,
      0.830888,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.962210,
      0,
      1.233983,
      NULL,
      1,
      1.621182,
      1,
      1.220697,
      0.287504,
      1.250160,
      0,
      0.182160,
      1.377137,
      0,
      1.517339,
      1.916874,
      NULL,
      1,
      0,
      5.698965,
      NULL,
      4,
      NULL,
      1,
      1,
      1.674090,
      NULL,
      NULL,
      NULL,
      5.205834,
      0.588269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166874,
      0.928776,
      0,
      1,
      1,
      1,
      1.411347,
      0.963167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.945959,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.887424,
      0,
      1,
      1,
      1.438948,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.334065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681412,
      NULL,
      2,
      0.670222,
      0.705479,
      1,
      0.988417,
      0.394473,
      NULL,
      0,
      1.052954,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1.228781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '4401',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      2.543270,
      3,
      3,
      3,
      0.420398,
      0.291294,
      1.499083,
      NULL);
commit;
end;
/


