set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9130391';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '343',
      '00',
      NULL,
      41.794516,
      '3413021',
      51.546772,
      3,
      1,
      3,
      '214323',
      NULL,
      '10- 0-1995',
      62,
      8.106620,
      1,
      NULL,
      0.478888,
      1,
      NULL,
      0.058820,
      1,
      NULL,
      NULL,
      2.178056,
      0,
      1,
      1.489535,
      1.403983,
      1,
      1.814677,
      0.611198,
      1,
      0.683483,
      NULL,
      0.933471,
      1,
      0.904051,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.243312,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.777727,
      0.276519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.893484,
      0.510675,
      1.072420,
      0,
      0,
      1,
      1,
      1.744969,
      0.199966,
      1.540829,
      1.903888,
      1.408959,
      1,
      1.549139,
      0,
      0.109204,
      0,
      1.098523,
      0.465838,
      NULL,
      0,
      0.321736,
      NULL,
      1.348093,
      NULL,
      0,
      NULL,
      1.804949,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1.275455,
      1.514004,
      0.483814,
      0.223867,
      NULL,
      0,
      1.844939,
      4,
      2,
      1.060769,
      1.325038,
      7.212014,
      0.864776,
      0.238582,
      NULL,
      NULL,
      5.726488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382223,
      0.276013,
      NULL,
      1,
      0.367299,
      0,
      1,
      1.663225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734713,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.321510,
      1.180896,
      0.678088,
      NULL,
      NULL,
      NULL,
      1.447234,
      0.181140,
      0,
      1,
      2,
      NULL,
      1.094876,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.253567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.674065,
      2,
      0.677846,
      NULL,
      NULL,
      NULL,
      2.165831,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.678043,
      NULL,
      '',
      '',
      0.860270,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      3.030580,
      0,
      2.984929,
      NULL,
      0.292407,
      3.324453,
      2,
      1.865315,
      2.799086);
commit;
end;
/


