set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9321577';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      NULL,
      4.317082,
      21.550711,
      '0143124',
      NULL,
      5,
      2.878211,
      3,
      '311043',
      5.718610,
      ' 2-10-1991',
      45.560796,
      3.783341,
      0.755995,
      NULL,
      3.256985,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1.661398,
      0.066291,
      1,
      5,
      1.036630,
      1,
      2.960578,
      1,
      3.605718,
      1,
      NULL,
      0.583484,
      1.293077,
      NULL,
      1.142393,
      2,
      0,
      0.731995,
      1,
      1.004464,
      1.554076,
      NULL,
      NULL,
      0.181332,
      NULL,
      NULL,
      0,
      1.461261,
      NULL,
      0.760641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646152,
      1.784904,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215210,
      1,
      1.680554,
      1,
      1.343438,
      NULL,
      1.677636,
      0.553224,
      NULL,
      1,
      1,
      NULL,
      1,
      1.083975,
      NULL,
      0.446130,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.390851,
      NULL,
      0,
      NULL,
      NULL,
      0.037240,
      1,
      0.907115,
      0.783703,
      0.838190,
      NULL,
      NULL,
      0,
      0.539915,
      NULL,
      1,
      5.229886,
      1.790309,
      4.346701,
      0.783217,
      4,
      0.982393,
      1,
      NULL,
      0,
      NULL,
      0.703564,
      1,
      NULL,
      NULL,
      3.134490,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856573,
      1.714284,
      1,
      1,
      NULL,
      0.061356,
      0.374300,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.957995,
      2,
      NULL,
      NULL,
      1.661040,
      2.883428,
      1,
      1,
      5.271117,
      2.758969,
      1.086009,
      1.577466,
      NULL,
      NULL,
      NULL,
      0.662022,
      0.208680,
      1,
      5,
      1.720801,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.330262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419974,
      0.924289,
      0,
      1,
      0,
      0.177567,
      0,
      0,
      1,
      0,
      0.410522,
      1.783651,
      1.938453,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.190818,
      1.679733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '30013',
      '22432',
      '',
      0.023694,
      '',
      NULL,
      '',
      1.890231,
      '',
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


