set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9321577';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      '10',
      21,
      31,
      '0443334',
      30.593487,
      4,
      2,
      0,
      '320420',
      5,
      '10-15-1992',
      73.771035,
      7.996201,
      0,
      NULL,
      0.988256,
      NULL,
      2.577053,
      1.682168,
      1.582906,
      0.488809,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      3,
      0,
      5,
      5,
      1.611739,
      1,
      3,
      NULL,
      0.419164,
      0,
      NULL,
      0,
      3,
      1,
      1.252698,
      NULL,
      NULL,
      NULL,
      0.767363,
      NULL,
      NULL,
      0.376242,
      0.822192,
      1.823214,
      0.996690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658185,
      NULL,
      0,
      0.402592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.621642,
      1.089049,
      1.678533,
      1.346395,
      1.251305,
      0,
      0,
      NULL,
      NULL,
      0.539702,
      1,
      NULL,
      NULL,
      1,
      0,
      1.239754,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1.308910,
      0.165467,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018639,
      NULL,
      1.195091,
      NULL,
      0.820648,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      0,
      0.001155,
      NULL,
      0.914758,
      0,
      3,
      1.308952,
      1,
      1,
      1.487023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.556053,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.462307,
      0,
      2,
      0,
      0,
      NULL,
      1.792182,
      0.741737,
      0,
      1,
      2,
      1,
      1.257085,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.089924,
      1,
      1.600575,
      1,
      1.810127,
      0,
      1.912629,
      2,
      0,
      0,
      0.113845,
      1.645973,
      1.652298,
      1,
      NULL,
      NULL,
      1,
      0.460696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      '44143',
      '21124',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      NULL,
      2,
      3.320371,
      0.408805,
      1.288440,
      NULL,
      3.461876,
      1.904712);
commit;
end;
/


