set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9849772';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '33412301',
      NULL,
      NULL,
      '2403311',
      5.109175,
      6,
      3.572602,
      NULL,
      '121204',
      NULL,
      ' 2-29-2003',
      NULL,
      62.438958,
      1.532349,
      NULL,
      2,
      NULL,
      3,
      1.742617,
      0,
      1.917602,
      0.494369,
      1.226556,
      NULL,
      0,
      6.626923,
      0.707250,
      0,
      0.537162,
      NULL,
      4.682194,
      7,
      0.125517,
      2.839868,
      0,
      10,
      1,
      6.481571,
      0,
      NULL,
      NULL,
      2,
      1.345441,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.058605,
      0.388447,
      6.863417,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.621171,
      2.426211,
      0.009148,
      1,
      NULL,
      0.336147,
      0,
      1.030690,
      NULL,
      1.079246,
      0,
      NULL,
      0,
      7.793689,
      8,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.519441,
      1.286645,
      NULL,
      1.810050,
      NULL,
      1.368517,
      NULL,
      0.156807,
      1.880978,
      0,
      1.399712,
      0,
      0,
      1.927857,
      0,
      0.275472,
      0.942456,
      NULL,
      1.095634,
      NULL,
      NULL,
      0.247110,
      1,
      1.807291,
      3.303779,
      0,
      0.984460,
      1,
      1,
      1,
      2,
      0,
      NULL,
      4,
      NULL,
      1.645153,
      2.914067,
      4.069643,
      3,
      2.645714,
      5.768065,
      NULL,
      3.283187,
      0.045186,
      1.766844,
      NULL,
      1,
      0.475234,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.267459,
      NULL,
      4,
      2,
      1.706181,
      2.401483,
      1.371248,
      0.113287,
      2.832347,
      0,
      0.514120,
      3,
      0.668897,
      0,
      NULL,
      NULL,
      NULL,
      4.431545,
      1.555320,
      1.772211,
      NULL,
      2.449585,
      1,
      0.853612,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.665948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.142127,
      2,
      0,
      NULL,
      0,
      0,
      0.756109,
      0.494843,
      0,
      0,
      NULL,
      1.438294,
      0.843317,
      NULL,
      0.245908,
      0,
      NULL,
      NULL,
      1.594839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '11010',
      '',
      '',
      0.455379,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      5,
      5.605579,
      2.569156,
      1,
      2.596005,
      5,
      2.909206,
      2.829127,
      NULL);
commit;
end;
/


