set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9849772';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '201',
      NULL,
      NULL,
      NULL,
      '4224344',
      NULL,
      0,
      NULL,
      1,
      NULL,
      5,
      '10- 7-1985',
      4.271465,
      32.598914,
      0.918127,
      NULL,
      1.449491,
      1.579304,
      NULL,
      0.295969,
      0.164923,
      NULL,
      1.877335,
      0.861481,
      3.118647,
      1.623984,
      5.759912,
      NULL,
      1.343077,
      0,
      0.980104,
      2,
      5.012090,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      2.285143,
      NULL,
      2,
      1.450613,
      NULL,
      NULL,
      0.317220,
      NULL,
      NULL,
      0.879881,
      0.281662,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.341168,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.147662,
      0.161280,
      NULL,
      0.648598,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.473372,
      1.100412,
      0.335642,
      0.794516,
      1,
      0.965008,
      0,
      NULL,
      1,
      3,
      0.566043,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1.532476,
      NULL,
      0,
      2.780299,
      0.943253,
      NULL,
      0.969580,
      4.782476,
      NULL,
      0.992836,
      0,
      0.835341,
      4.841157,
      6.176212,
      0,
      0.477087,
      0.278644,
      1.982204,
      0.953655,
      0,
      NULL,
      NULL,
      3.314454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.998927,
      0,
      1,
      0,
      0.335892,
      1.417366,
      0.958000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.418002,
      NULL,
      0,
      1.537755,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.140240,
      3.728072,
      3,
      0,
      0,
      1.523092,
      NULL,
      NULL,
      NULL,
      0.371602,
      1,
      0.122915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.905136,
      1,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2.010562,
      1.370948,
      NULL,
      0.583473,
      0,
      NULL,
      1.659815,
      0.450166,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.697851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.804863,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186456,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.977201,
      4,
      1.967363,
      NULL,
      0,
      2,
      3.228147,
      NULL,
      '10400',
      '',
      0,
      '',
      '',
      '',
      2.268485,
      '1232',
      '',
      NULL,
      4.021241,
      NULL,
      0.506680,
      0,
      NULL,
      0.073839,
      3.998502,
      4,
      3.370741);
commit;
end;
/


